<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Mservicio extends CI_Model {

    function __construct() {
        parent::__construct();
    }
    
    function getCda(){
        $query = $this->db->get('cda');
        $query = $query->result();
        return $query[0]->nombre;
    }

    function getDevice($serial) {
        $this->db->where('mac', $serial);
        $query = $this->db->get('dispositivo');
        return $query;
    }


function guardarDispositivo($dispositivo) {
    $dev = $this->getDevice($dispositivo['mac']);
    if ($dev->num_rows() !== 0) {
        return 'SI';
    } else {
        $dis = explode('|', $dispositivo['descripcion']);
        if (count($dis) > 1) {
            $marca = $dis[0];
            $modelo = $dis[1];
            if ($modelo == 'LENOVO YT3-X50M') {
                $dispositivo['activo'] = "1";
            }
            $maquina['marca'] = $marca;
            $maquina['serie_maquina'] = $modelo;
            $maquina['serie_banco'] = $dispositivo['mac'];
            $maquina['idconf_linea_inspeccion'] = '6';
            $maquina['nombre'] = 'camara';
            $maquina['idconf_tipo_prueba'] = '5';
            $this->crearMaquina($maquina);
	    $maquina['nombre'] = 'visual';	
            $maquina['idconf_tipo_prueba'] = '8';
            $this->crearMaquina($maquina);
        }
        $this->db->insert("dispositivo", $dispositivo);
        $this->db->insert_id();
        return 'NO';
    }
}

function crearMaquina($maquina) {
    $this->db->insert("conf_maquina", $maquina);
    $configuracion['idconf_maquina'] = $this->db->insert_id();
    $configuracion['nombre'] = 'nombreMarca';
    $configuracion['valor'] = $maquina['marca'];
    $configuracion['descripcion'] = 'Marca del dispositivo';
    $this->crearConfiguracion($configuracion);
    $configuracion['nombre'] = 'activo';
    $configuracion['valor'] = "1";
    $configuracion['descripcion'] = 'Dispositivo activo';
    $this->crearConfiguracion($configuracion);
}

function crearConfiguracion($configuracion) {
    $this->db->insert("conf_dato_maquina", $configuracion);
}    
    function getLicencia() {
        $result = $this->db->query("SELECT 
d.mac,d.activo,TIMESTAMPDIFF(DAY, DATE_FORMAT(NOW(),'%Y-%m-%d'), DATE_FORMAT(c.fechafinal,'%Y-%m-%d')) dias,c.activo cdaactivo,c.fechafinal FROM dispositivo d,cda c;");
        return $result;
    }
    
      function getLineas() {
        $result = $this->db->query("select 
li.idconf_linea_inspeccion,m.idconf_maquina,m.nombre,m.marca,m.serie_maquina,m.serie_banco,tp.nombre prueba,tp.conf_idtipo_prueba,
IFNULL((SELECT valor FROM conf_dato_maquina WHERE nombre='activo' AND idconf_maquina=m.idconf_maquina LIMIT 1),'1') activo
from 
conf_maquina m,conf_linea_inspeccion li,conf_tipo_prueba tp
where 
li.idconf_linea_inspeccion=m.idconf_linea_inspeccion and
tp.conf_idtipo_prueba=m.idconf_tipo_prueba;");
        return $result;
    }
    
    function getConfMaquina($idmaquina){
        $result = $this->db->query("select * from conf_dato_maquina where idconf_maquina=$idmaquina;");
        return $result;
    }
    
    function insertMercadeo($data){
        $this->db->insert('mercadeo', $data);
    }
    
    function insertAuditoria($data){
        $this->db->insert('auditoria', $data);
    }

}